-- 指定したボーンのスケールを変更する関数
function SetBoneScale(entityId, boneName, scaleX, scaleY, scaleZ)
    -- キャラクターのエンティティを取得
    local entity = Sys:GetEntity(entityId)
    if entity == nil then
        Sys:Message("エンティティが見つかりません")
        return
    end

    -- モデルの取得
    local model = entity:GetModel()
    if model == nil then
        Sys:Message("モデルが見つかりません")
        return
    end

    -- ボーンの取得
    local bone = model:GetBone(boneName)
    if bone == nil then
        Sys:Message("指定したボーンが見つかりません: " .. boneName)
        return
    end

    -- ボーンのスケールを変更
    bone:SetScale(scaleX, scaleY, scaleZ)
    Sys:Message("ボーン " .. boneName .. " のスケールを変更しました")
end
